import re
import os

def generate_experiment_filename(
    model_name,
    layer: int,
    optimization_method: str,
    substitutor: str,
    num_substitutions: int,
    judge: bool,
    data_name: str,
) -> str:
   
    model_name = re.sub('([a-z0-9])([A-Z])', r'\1_\2', model_name).lower()
    #create results directory if it doesn't exist
    if not os.path.exists(f'./Results/{model_name}'):
        os.makedirs(f'./Results/{model_name}')
    
    # Clean up model name
    

    # Clean up optimization method name
    opt_method = optimization_method.lower().strip()

    if judge:
        judge = "J"
    else:
        judge = "NJ"

    # Construct filename with new parameters
    filename = (
        f"{model_name}_"
        f"layer{layer}_"
        f"{substitutor}"
        f"subs{num_substitutions}_"
        f"{opt_method}_"
        f"{judge}_"
        f"{data_name}.json"

    )

    # path to filename
    filename = os.path.join(f"./Results/{model_name}", filename)

    return filename